//LidScrewHeads.scad;

//Use LidScrewHead four times to generate 
//four holes for four heads for four screws;

//LidScrewHead generates one screw head 
//object centered at the origin, 
//with the screw head resting on the 
//XY plane and the screw thread 
//standing vertically above that plane;

include <UNO_Dimensions.scad>
use <UNO_LidScrewHead.scad>;

module LidScrewHeads()
{

echo("Begin LidScrewHeads");
    
//DeltaZ is constant for all screws;
DeltaZ = -Fuzz;

//Four screw objects;
echo("BL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
    LidScrewHead();

echo("BR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
    LidScrewHead();

echo("TR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
    LidScrewHead();

echo("TL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
    LidScrewHead();

}
//
